% matlab code for drawing distribution of Q

numStates = 20;

P = [0.1 * ones(1, numStates-1), 1];

scale = 0.01; % due to 100:1 scaling in the test.lua
gamma = 0.9;

numSamples = [200];

for j = 1 : size(numSamples, 2)

    Q = importdata("../data/170510_145110_"+numSamples(j)+".v.txt");
    Q = Q(Q>0) * scale;
    meanQ = mean(Q);
    muQ = log((meanQ^2)/sqrt(std(Q)^2+meanQ^2));

    N = numSamples(j) * ones(1, numStates);
    [meanQ, stdQ] = EstimateMeanStdQ(gamma, P, N);
    sigmaQ = sqrt(log(stdQ^2/(meanQ^2)+1));
    
    figure;
    histogram(Q, 40, 'Normalization','pdf');
    
    hold on;
    x = 0:0.01:50;
    y = lognpdf(x, muQ, sigmaQ);
    plot(x, y);
    
    xlim([-1, 20]);
    xlabel('estimated value')
    ylabel('density')
    legend('sample distribution', 'theoretical distribution')
    
    hold off;
end
